/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "led.h"
#include "dm388_types.h"
#include "gpio.h"
#include "dm388_EVM.h"


/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  led_test( )                                                            *
 *      Running LED test                                                   *
 *                                                                          *
 * ------------------------------------------------------------------------ */

void led_pin_mux()
{
	/* GP3[3] configuration  */
	WR_MEM_32(PINCNTL211, 0x00040080);

	/* GP0[9] configuration  */
	WR_MEM_32(PINCNTL16,  0x000C0080);

	/* GP1[24] configuration  */
	WR_MEM_32(PINCNTL123, 0x00060080);

	/* GP1[25] configuration  */
	WR_MEM_32(PINCNTL124, 0x00060080);

	/* GP1[30] configuration  */
	WR_MEM_32(PINCNTL132, 0x00040080);
}

void LED_init(void)
{
	UINT32 regval;

	//led_pin_mux();

	//LEDInit();
	/* Reset GPIO1 Subsystem */
	GPIO1_SYSCONFIG = 0x0000002; /* Software Reset */
	DM388_wait(0x90000);
	GPIO1_SYSCONFIG = 0x100; /* no-idle */

	/* Output Enable GPIO24 in Bank 1 */
	regval = GPIO1_OE;
	regval = regval & ~(1 << LED_NUM_GP1_24);
	GPIO1_OE = regval;

	/* Output Enable GPIO25 in Bank 1 */
	regval = GPIO1_OE;
	regval = regval & ~(1 << LED_NUM_GP1_25);
	GPIO1_OE = regval;

	/* Output Enable GPIO30 in Bank 1 */
	regval = GPIO1_OE;
	regval = regval & ~(1 << LED_NUM_GP1_30);
	GPIO1_OE = regval;

	/* Reset GPIO0 Subsystem */
	GPIO0_SYSCONFIG = 0x00000002; /* Software Reset */
	DM388_wait(0x90000);
	GPIO0_SYSCONFIG = 0x100; /* no-idle */

	/* Output Enable GPIO9 in Bank 0 */
	regval = GPIO0_OE;
	regval = regval & ~(1 << LED_NUM_GP0_9);
	GPIO0_OE = regval;

	/* Reset GPIO3 Subsystem */
	GPIO3_SYSCONFIG = 0x00000002; /* Software Reset */
	DM388_wait(0x90000);
	GPIO3_SYSCONFIG = 0x100; /* no-idle */

	/* Output Enable GPIO3 in Bank 3 */
	regval = GPIO3_OE;
	regval = regval & ~(1 << LED_NUM_GP3_3);
	GPIO3_OE = regval;


}

void LED_on(UINT16 LED_num,UINT16 bank)
{
	if(GPIO_BANK_0 == bank)
	{
		GPIO0_SETDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_1 == bank)
	{
		GPIO1_SETDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_3 == bank)
	{
		GPIO3_SETDATAOUT = (1 << LED_num);
	}
}

void LED_off(UINT16 LED_num,UINT16 bank)
{

	if(GPIO_BANK_0 == bank)
	{
		GPIO0_CLEARDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_1 == bank)
	{
		GPIO1_CLEARDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_3 == bank)
	{
		GPIO3_CLEARDATAOUT = (1 << LED_num);
	}
}

INT32 led_test(void *testargs)
{  
    platform_write("\n************************\n\r");
    platform_write(  "         Led Test       \n\r");
    platform_write(  "************************\n\r");
	UINT32 i;

    /* Initialize the LED module */
    LED_init( );

    platform_write("\nRunning LED Toggle Test\n");
	LED_on(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
	DM388_wait( LED_DELAY );
    LED_on(LED_NUM_GP1_24, GPIO_BANK_1);  //LED2
    DM388_wait( LED_DELAY );
    LED_on(LED_NUM_GP1_25, GPIO_BANK_1);  //LED3
    DM388_wait( LED_DELAY );
    LED_on(LED_NUM_GP0_9, GPIO_BANK_0);   //LED5
    DM388_wait( LED_DELAY );
    LED_on(LED_NUM_GP3_3, GPIO_BANK_3);   //LED4
    DM388_wait( LED_DELAY );
    DM388_wait( LED_DELAY );
    DM388_wait( LED_DELAY );

	LED_off(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
	DM388_wait( LED_DELAY );
	LED_off(LED_NUM_GP1_24, GPIO_BANK_1);  //LED2
	DM388_wait( LED_DELAY );
	LED_off(LED_NUM_GP1_25, GPIO_BANK_1);  //LED3
	DM388_wait( LED_DELAY );
	LED_off(LED_NUM_GP0_9, GPIO_BANK_0);   //LED5
	DM388_wait( LED_DELAY );
	LED_off(LED_NUM_GP3_3, GPIO_BANK_3);   //LED4
	DM388_wait( LED_DELAY );

	for ( i = 0 ; i < 5 ; i++ )
	{
		LED_on(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
		LED_on(LED_NUM_GP1_24, GPIO_BANK_1);  //LED2
		LED_on(LED_NUM_GP1_25, GPIO_BANK_1);  //LED3
		LED_on(LED_NUM_GP0_9, GPIO_BANK_0);   //LED5
		LED_on(LED_NUM_GP3_3, GPIO_BANK_3);   //LED4
		DM388_wait( LED_DELAY );

		LED_off(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
		LED_off(LED_NUM_GP1_24, GPIO_BANK_1);  //LED2
		LED_off(LED_NUM_GP1_25, GPIO_BANK_1);  //LED3
		LED_off(LED_NUM_GP0_9, GPIO_BANK_0);   //LED5
		LED_off(LED_NUM_GP3_3, GPIO_BANK_3);   //LED4
		DM388_wait( LED_DELAY );
	}
	platform_write("LED Toggle Test Completed\n");
	platform_write("However, actual results are to be judged based on the observation\n");
	platform_write("\nLED Test Completed!!\n");
    return 0;
}
